unit client_main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, XPMan, XMLIntf, XMLDoc, ComCtrls, IdHTTP;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    IdTCPClient1: TIdTCPClient;
    Memo1: TMemo;
    Button2: TButton;
    Button3: TButton;
    Button1: TButton;
    Memo2: TMemo;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Label9: TLabel;
    Edit10: TEdit;
    TabSheet3: TTabSheet;
    Label11: TLabel;
    Edit12: TEdit;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Label13: TLabel;
    TabSheet4: TTabSheet;
    Button7: TButton;
    Label8: TLabel;
    Edit_UserData: TEdit;
    Label10: TLabel;
    CheckBox1: TCheckBox;
    Label12: TLabel;
    Label14: TLabel;
    Edit9: TEdit;
    Edit11: TEdit;
    TabSheet5: TTabSheet;
    Label15: TLabel;
    Edit13: TEdit;
    Label16: TLabel;
    Edit14: TEdit;
    Label17: TLabel;
    Label18: TLabel;
    Edit15: TEdit;
    TabSheet6: TTabSheet;
    Label19: TLabel;
    Label20: TLabel;
    Edit16: TEdit;
    Edit17: TEdit;
    TabSheet7: TTabSheet;
    Label21: TLabel;
    Edit18: TEdit;
    TabSheet8: TTabSheet;
    Label22: TLabel;
    Edit19: TEdit;
    Label23: TLabel;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    TabSheet9: TTabSheet;
    Label24: TLabel;
    Edit20: TEdit;
    TabSheet10: TTabSheet;
    Label25: TLabel;
    Edit21: TEdit;
    TabSheet11: TTabSheet;
    Label26: TLabel;
    Edit22: TEdit;
    TabSheet12: TTabSheet;
    Label27: TLabel;
    Edit23: TEdit;
    TabSheet13: TTabSheet;
    Edit24: TEdit;
    Label28: TLabel;
    Label29: TLabel;
    Edit25: TEdit;
    Label30: TLabel;
    Edit26: TEdit;
    TabSheet14: TTabSheet;
    Label31: TLabel;
    Edit27: TEdit;
    TabSheet15: TTabSheet;
    Label32: TLabel;
    TabSheet16: TTabSheet;
    Label33: TLabel;
    Edit28: TEdit;
    Label34: TLabel;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    TabSheet17: TTabSheet;
    Label35: TLabel;
    TabSheet18: TTabSheet;
    TabSheet19: TTabSheet;
    Label36: TLabel;
    Edit29: TEdit;
    RadioButton7: TRadioButton;
    RadioButton8: TRadioButton;
    Label37: TLabel;
    Label38: TLabel;
    Edit30: TEdit;
    Edit31: TEdit;
    Label39: TLabel;
    Edit32: TEdit;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Label43: TLabel;
    Edit33: TEdit;
    Label44: TLabel;
    Edit34: TEdit;
    Label46: TLabel;
    Edit36: TEdit;
    TabSheet22: TTabSheet;
    TabSheet23: TTabSheet;
    Label47: TLabel;
    Edit37: TEdit;
    Label48: TLabel;
    Edit38: TEdit;
    Label49: TLabel;
    Edit39: TEdit;
    Label50: TLabel;
    ComboBox3: TComboBox;
    TabSheet26: TTabSheet;
    ListBox1: TListBox;
    Label45: TLabel;
    Edit35: TEdit;
    Button4: TButton;
    IdHTTP1: TIdHTTP;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
    function CodeItemIssue : String;
    function CodeTicketsErase : String;
    function CodeExit : String;
    function CodeBill : String;
    function CodeCardDelivery : String;
    function CodeUnlock : String;
    function CodeCardInfo : String;
    function CodeBlackList : String;
    function CodeWhiteList : String;
    function CodeCardInfo01 : String;
    function CodeCardInfo02 : String;
    function CodeDisable : String;
    function CodeRepair : String;
    function CodeGetCard : String;
    function CodeExternalDeliveryInfo : String;
    function CodeExternalDeliveryPost : String;
    function CodeBarcode : String;
    function CodeOccupation : String;
    function CodeExternal : String;
    function CodeLockerInfo : String;
    function CodeLockersInfo : String;
    function LoadFromFile( const s : String ) : String;
    function SendReceive( const buffer : String ) : String;
    function SendReceiveHTTP( const buffer : String ) : String;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

function TForm1.CodeItemIssue : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
  mode : String;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'ItemIssue';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  if Edit7.Text <> '' then parameters.AddChild( 'pos' ).NodeValue := Edit7.Text;
  if Edit8.Text <> '' then parameters.AddChild( 'user' ).NodeValue := Edit8.Text;
  parameters.AddChild( 'item' ).NodeValue := Edit3.Text;
  parameters.AddChild( 'card' ).NodeValue := Edit4.Text;
  if Edit5.Text <> '' then parameters.AddChild( 'datetimefrom' ).NodeValue := FormatDateTime( 'yyyy"-"mm"-"dd"T"hh":"nn":"ss', StrToDateTime( Edit5.Text ) );
  if Edit6.Text <> '' then parameters.AddChild( 'datetimeto' ).NodeValue := FormatDateTime( 'yyyy"-"mm"-"dd"T"hh":"nn":"ss', StrToDateTime( Edit6.Text ) );
  if Edit34.Text <> '' then parameters.AddChild( 'param' ).NodeValue := Edit34.Text;

  mode := '';
  if Edit33.Text <> '' then
    begin
      mode := 'WristbandIssuer';
      parameters.AddChild( 'issuedevice' ).NodeValue := Edit33.Text;
    end;
  if mode <> '' then parameters.AddChild( 'mode' ).NodeValue := mode;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeTicketsErase : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'TicketsErase';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'card' ).NodeValue := Edit10.Text;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeExit : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'Exit';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'card' ).NodeValue := Edit12.Text;
  if RadioButton1.Checked then parameters.AddChild( 'exit' ).NodeValue := 'allow';
  if RadioButton2.Checked then parameters.AddChild( 'exit' ).NodeValue := 'deny';

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeBill : String;
var
  package, header, parameters, items, item, tax, payments, payment : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'Bill';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  if Edit9.Text <> '' then parameters.AddChild( 'pos' ).NodeValue := Edit9.Text;
  if Edit11.Text <> '' then parameters.AddChild( 'user' ).NodeValue := Edit11.Text;

  items := parameters.AddChild( 'items' );

  item := items.AddChild( 'item' );
  item.AddChild( 'id' ).NodeValue := '# 100';
  item.AddChild( 'import' ).NodeValue := 'abc100';
  item.AddChild( 'value' ).NodeValue := '1.2';
  tax := item.AddChild( 'tax' );
  tax.AddChild( 'id' ).NodeValue := '1';
  tax.AddChild( 'import' ).NodeValue := 'T1';
  tax.AddChild( 'tax' ).NodeValue := '20.0';
  tax.AddChild( 'value' ).NodeValue := '0.2';
  item.AddChild( 'num' ).NodeValue := '5';

  item := items.AddChild( 'item' );
  item.AddChild( 'id' ).NodeValue := '# 100';
  item.AddChild( 'import' ).NodeValue := 'abc100';
  item.AddChild( 'value' ).NodeValue := '1.2';
  tax := item.AddChild( 'tax' );
  tax.AddChild( 'id' ).NodeValue := '1';
  tax.AddChild( 'import' ).NodeValue := 'T1';
  tax.AddChild( 'tax' ).NodeValue := '20.0';
  tax.AddChild( 'value' ).NodeValue := '0.2';
  item.AddChild( 'num' ).NodeValue := '5';

  payments := parameters.AddChild( 'payments' );

  payment := payments.AddChild( 'payment' );
  payment.AddChild( 'id' ).NodeValue := '1';
  payment.AddChild( 'import' ).NodeValue := 'P0001';
  payment.AddChild( 'value' ).NodeValue := '59.6';

  payment := payments.AddChild( 'payment' );
  payment.AddChild( 'id' ).NodeValue := '1';
  payment.AddChild( 'import' ).NodeValue := 'P0001';
  payment.AddChild( 'count' ).NodeValue := '140';
  payment.AddChild( 'value' ).NodeValue := '1400';

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeCardDelivery : String;
var
  package, header, parameters, items, item, tax : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'CardDelivery';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  if Edit13.Text <> '' then parameters.AddChild( 'pos' ).NodeValue := Edit13.Text;
  if Edit14.Text <> '' then parameters.AddChild( 'user' ).NodeValue := Edit14.Text;
  parameters.AddChild( 'card' ).NodeValue := Edit15.Text;

  items := parameters.AddChild( 'items' );

  item := items.AddChild( 'item' );
  item.AddChild( 'id' ).NodeValue := '# 100';
  item.AddChild( 'import' ).NodeValue := 'abc100';
  item.AddChild( 'value' ).NodeValue := '1.2';
  tax := item.AddChild( 'tax' );
  tax.AddChild( 'id' ).NodeValue := '1';
  tax.AddChild( 'import' ).NodeValue := 'T1';
  tax.AddChild( 'tax' ).NodeValue := '20.0';
  tax.AddChild( 'value' ).NodeValue := '0.2';
  item.AddChild( 'num' ).NodeValue := '5';

  item := items.AddChild( 'item' );
  item.AddChild( 'id' ).NodeValue := '# 100';
  item.AddChild( 'import' ).NodeValue := 'abc100';
  item.AddChild( 'value' ).NodeValue := '1.2';
  tax := item.AddChild( 'tax' );
  tax.AddChild( 'id' ).NodeValue := '1';
  tax.AddChild( 'import' ).NodeValue := 'T1';
  tax.AddChild( 'tax' ).NodeValue := '20.0';
  tax.AddChild( 'value' ).NodeValue := '0.2';
  item.AddChild( 'num' ).NodeValue := '5';

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeUnlock : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'Unlock';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'locker' ).NodeValue := Edit16.Text;
  if Edit17.Text <> '' then parameters.AddChild( 'location' ).NodeValue := Edit17.Text;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeCardInfo : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'CardInfo';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'card' ).NodeValue := Edit18.Text;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeBlackList : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'BlackList';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'card' ).NodeValue := Edit19.Text;
  if RadioButton3.Checked then parameters.AddChild( 'blacklist' ).NodeValue := 'add';
  if RadioButton4.Checked then parameters.AddChild( 'blacklist' ).NodeValue := 'remove';

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeWhiteList : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'WhiteList';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'card' ).NodeValue := Edit28.Text;
  if RadioButton5.Checked then parameters.AddChild( 'whitelist' ).NodeValue := 'add';
  if RadioButton6.Checked then parameters.AddChild( 'whitelist' ).NodeValue := 'remove';

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeCardInfo01 : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'CardInfo01';
  header.AddChild( 'version' ).NodeValue := ComboBox3.Text;

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'card' ).NodeValue := Edit20.Text;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeCardInfo02 : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'CardInfo02';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'card' ).NodeValue := Edit23.Text;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeDisable : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'Disable';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'card' ).NodeValue := Edit21.Text;
  parameters.AddChild( 'refund' ).NodeValue := 'disable';

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeRepair : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'Repair';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'card' ).NodeValue := Edit22.Text;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeGetCard : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'GetCard';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  if Edit24.Text <> '' then parameters.AddChild( 'pos' ).NodeValue := Edit24.Text;
  if Edit25.Text <> '' then parameters.AddChild( 'device' ).NodeValue := Edit25.Text;
  parameters.AddChild( 'timeout' ).NodeValue := Edit26.Text;
  if Edit36.Text <> '' then parameters.AddChild( 'issuecount' ).NodeValue := Edit36.Text;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeExternalDeliveryInfo : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'ExternalDeliveryInfo';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'querydata' ).NodeValue := Edit27.Text;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeExternalDeliveryPost : String;
var
  package, header, parameters, items, item, discount, tax : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'ExternalDeliveryPost';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'pos' ).NodeValue := 1;
  parameters.AddChild( 'user' ).NodeValue := 2;
  parameters.AddChild( 'doc' ).NodeValue := '1/2005/123456';
  parameters.AddChild( 'id' ).NodeValue := 'ABC123';

  items := parameters.AddChild( 'items' );

  item := items.AddChild( 'item' );
  item.AddChild( 'id' ).NodeValue := '# 100';
  item.AddChild( 'export' ).NodeValue := 'abc100';
  item.AddChild( 'price' ).NodeValue := '2.4';
  discount := item.AddChild( 'discount' );
  discount.AddChild( 'id' ).NodeValue := '2';
  discount.AddChild( 'rate' ).NodeValue := '50';
  discount.AddChild( 'export' ).NodeValue := 'd2';
  discount.AddChild( 'value' ).NodeValue := '1.2';
  item.AddChild( 'value' ).NodeValue := '1.2';
  tax := item.AddChild( 'tax' );
  tax.AddChild( 'id' ).NodeValue := '1';
  tax.AddChild( 'rate' ).NodeValue := '20.0';
  tax.AddChild( 'export' ).NodeValue := 'T1';
  tax.AddChild( 'value' ).NodeValue := '0.2';
  item.AddChild( 'num' ).NodeValue := '5';

  item := items.AddChild( 'item' );
  item.AddChild( 'id' ).NodeValue := '# 105';
  item.AddChild( 'export' ).NodeValue := 'abc105';
  item.AddChild( 'price' ).NodeValue := '1085';
  item.AddChild( 'value' ).NodeValue := '1085';
  tax := item.AddChild( 'tax' );
  tax.AddChild( 'id' ).NodeValue := '2';
  tax.AddChild( 'export' ).NodeValue := 'T2';
  tax.AddChild( 'tax' ).NodeValue := '8.5';
  tax.AddChild( 'value' ).NodeValue := '85';
  item.AddChild( 'num' ).NodeValue := '2';

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeBarcode : String;
var
  package, header, parameters, document, head, pos, items, item : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'Barcode';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'barcode' ).NodeValue := 'ABCD1234EF56AB78';
  parameters.AddChild( 'value' ).NodeValue := '7.5';

  document := parameters.AddChild( 'document' );

  head := document.AddChild( 'head' );
  head.AddChild( 'documenttype' ).NodeValue := 'sale';
  pos := head.AddChild( 'pos' );
  pos.AddChild( 'id' ).NodeValue := '1';
  pos.AddChild( 'export' ).NodeValue := 'M01';
  head.AddChild( 'year' ).NodeValue := '2006';
  head.AddChild( 'doc_id' ).NodeValue := '10123';
  head.AddChild( 'inv_id' ).NodeValue := '10100';
  head.AddChild( 'dt' ).NodeValue := '2007-09-17T09:50:00';
  head.AddChild( 'user' ).NodeValue := '2';

  items := document.AddChild( 'items' );

  item := items.AddChild( 'item' );
  item.AddChild( 'id' ).NodeValue := 'A00200123';
  item.AddChild( 'export' ).NodeValue := 'ABC123';
  item.AddChild( 'value' ).NodeValue := '5';

  item := items.AddChild( 'item' );
  item.AddChild( 'id' ).NodeValue := 'A00200125';
  item.AddChild( 'export' ).NodeValue := 'ABC125';
  item.AddChild( 'value' ).NodeValue := '2.5';

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeOccupation : String;
var
  package, header : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'Occupation';
  header.AddChild( 'version' ).NodeValue := '1.0';

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeExternal : String;
var
  package, header, parameters, lockers, locker : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'External';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  parameters.AddChild( 'card' ).NodeValue := Edit29.Text;
  if Edit30.Text <> '' then parameters.AddChild( 'quota' ).NodeValue := Edit30.Text;
  if Edit31.Text <> '' then parameters.AddChild( 'iddevice' ).NodeValue := Edit31.Text;
  if Edit32.Text <> '' then parameters.AddChild( 'idpassage' ).NodeValue := Edit32.Text;
  if RadioButton7.Checked then parameters.AddChild( 'direction' ).NodeValue := 'entrance';
  if RadioButton8.Checked then parameters.AddChild( 'direction' ).NodeValue := 'exit';
  if ComboBox1.ItemIndex = 1 then
    begin
      lockers := parameters.AddChild( 'lockers' );
      locker := lockers.AddChild( 'locker' );
      locker.AddChild( 'location' ).NodeValue := 1;
      locker.AddChild( 'number' ).NodeValue := 1234;
      locker.AddChild( 'dt' ).NodeValue := FormatDateTime( 'yyyy"-"mm"-"dd"T"hh":"nn":"ss', Now - 1 / 24 );
    end;
  if ComboBox1.ItemIndex = 2 then
    begin
      lockers := parameters.AddChild( 'lockers' );
      locker := lockers.AddChild( 'locker' );
      locker.AddChild( 'location' ).NodeValue := 1;
      locker.AddChild( 'number' ).NodeValue := 1234;
      locker.AddChild( 'dt' ).NodeValue := FormatDateTime( 'yyyy"-"mm"-"dd"T"hh":"nn":"ss', Now - 1 / 24 );
      locker := lockers.AddChild( 'locker' );
      locker.AddChild( 'location' ).NodeValue := 1;
      locker.AddChild( 'number' ).NodeValue := 5678;
      locker.AddChild( 'dt' ).NodeValue := FormatDateTime( 'yyyy"-"mm"-"dd"T"hh":"nn":"ss', Now - 2 / 24 );
    end;
  if ComboBox2.ItemIndex = 1 then
    parameters.AddChild( 'wbc' ).AddChild( 'state' ).NodeValue := 'warning';
  if ComboBox2.ItemIndex = 2 then
    parameters.AddChild( 'wbc' ).AddChild( 'state' ).NodeValue := 'alarm';

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeLockerInfo : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'LockerInfo';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  if Edit37.Text <> '' then parameters.AddChild( 'location' ).NodeValue := Edit37.Text;
  parameters.AddChild( 'locker' ).NodeValue := Edit38.Text;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.CodeLockersInfo : String;
var
  package, header, parameters : IXMLNode;
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  if CheckBox1.Checked then xmld.Options := xmld.Options + [ doNodeAutoIndent ];
  xmld.Encoding := 'UTF-8';
  xmld.StandAlone := 'yes';

  package := xmld.AddChild( 'package' );

  header := package.AddChild( 'header' );
  header.AddChild( 'name' ).NodeValue := 'LockersInfo';
  header.AddChild( 'version' ).NodeValue := '1.0';

  parameters := package.AddChild( 'parameters' );
  if Edit39.Text <> '' then parameters.AddChild( 'location' ).NodeValue := Edit39.Text;

  if Edit_UserData.Text <> '' then package.AddChild( 'userdata' ).NodeValue := Edit_UserData.Text;

  Result := xmld.XML.Text;
end;

function TForm1.LoadFromFile( const s : String ) : String;
var
  xmld : IXMLDocument;
begin
  xmld := NewXMLDocument;
  xmld.LoadFromFile( ExtractFilePath( Application.ExeName ) + s );
  Result := xmld.XML.Text;
end;

function TForm1.SendReceive( const buffer : String ) : String;
var
  ch : Char;
begin
  IdTCPClient1.Write( #2 + buffer + #3 );
  Result := '';
  repeat
    ch := IdTCPClient1.ReadChar;
    case ch of
      #0 : ;
      #2 : Result := '';
      #3 : Break;
      else Result := Result + ch;
    end;
  until False;
end;

function TForm1.SendReceiveHTTP( const buffer : String ) : String;
var
  ss, x : TStringStream;
begin
  x := TStringStream.Create( buffer );
  try
    ss := TStringStream.Create( '' );
    try
      IdHTTP1.Post( Edit35.Text, x, ss );
      Result := ss.DataString;
    finally
      ss.Free;
    end;
  finally
    x.Free;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
  procedure FilesToList;
  var
    Result : Integer;
    SearchRec : TSearchRec;
  begin
    ListBox1.Items.Clear;
    Result := FindFirst( '*.xml', faAnyFile, SearchRec);
    while Result = 0 do
      begin
        if ( SearchRec.Name <> '.' ) and
           ( SearchRec.Name <> '..' ) then
          begin
            ListBox1.Items.Add( SearchRec.Name )
          end;
        Result := FindNext(SearchRec);
      end;
    FindClose(SearchRec);
  end;
begin
  Caption := Application.Title;
  Edit5.Text := DateTimeToStr( Now );
  Edit6.Text := DateTimeToStr( Now + 1 );
  FilesToList;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Memo2.Lines.Clear;
  Memo2.Lines.Text := SendReceive( Memo1.Lines.Text );
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  IdTCPClient1.Host := Edit1.Text;
  IdTCPClient1.Port := StrToInt( Edit2.Text );
  IdTCPClient1.Connect;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  IdTCPClient1.Disconnect;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  Memo1.Lines.Clear;

  if PageControl1.ActivePage = TabSheet26 then
    begin

      Memo1.Lines.Text := LoadFromFile( ListBox1.Items[ ListBox1.ItemIndex ] );
      Exit;
    end;

  if PageControl1.ActivePage = TabSheet1  then Memo1.Lines.Text := CodeItemIssue;
  if PageControl1.ActivePage = TabSheet2  then Memo1.Lines.Text := CodeTicketsErase;
  if PageControl1.ActivePage = TabSheet3  then Memo1.Lines.Text := CodeExit;
  if PageControl1.ActivePage = TabSheet4  then Memo1.Lines.Text := CodeBill;
  if PageControl1.ActivePage = TabSheet5  then Memo1.Lines.Text := CodeCardDelivery;
  if PageControl1.ActivePage = TabSheet6  then Memo1.Lines.Text := CodeUnlock;
  if PageControl1.ActivePage = TabSheet7  then Memo1.Lines.Text := CodeCardInfo;
  if PageControl1.ActivePage = TabSheet8  then Memo1.Lines.Text := CodeBlackList;
  if PageControl1.ActivePage = TabSheet9  then Memo1.Lines.Text := CodeCardInfo01;
  if PageControl1.ActivePage = TabSheet10 then Memo1.Lines.Text := CodeDisable;
  if PageControl1.ActivePage = TabSheet11 then Memo1.Lines.Text := CodeRepair;
  if PageControl1.ActivePage = TabSheet12 then Memo1.Lines.Text := CodeCardInfo02;
  if PageControl1.ActivePage = TabSheet13 then Memo1.Lines.Text := CodeGetCard;
  if PageControl1.ActivePage = TabSheet14 then Memo1.Lines.Text := CodeExternalDeliveryInfo;
  if PageControl1.ActivePage = TabSheet15 then Memo1.Lines.Text := CodeExternalDeliveryPost;
  if PageControl1.ActivePage = TabSheet16 then Memo1.Lines.Text := CodeWhiteList;
  if PageControl1.ActivePage = TabSheet17 then Memo1.Lines.Text := CodeBarcode;
  if PageControl1.ActivePage = TabSheet18 then Memo1.Lines.Text := CodeOccupation;
  if PageControl1.ActivePage = TabSheet19 then Memo1.Lines.Text := CodeExternal;
  if PageControl1.ActivePage = TabSheet22 then Memo1.Lines.Text := CodeLockerInfo;
  if PageControl1.ActivePage = TabSheet23 then Memo1.Lines.Text := CodeLockersInfo;
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
begin
  Button7.Click;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  Memo2.Lines.Clear;
  Memo2.Lines.Text := SendReceiveHTTP( Memo1.Lines.Text );
end;

end.
