unit server_main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IdBaseComponent, IdComponent, IdTCPServer, StdCtrls, XPMan, XMLIntf,
  XMLDoc, ActiveX, ComCtrls, IdCustomHTTPServer, IdHTTPServer;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    IdTCPServer1: TIdTCPServer;
    Button2: TButton;
    Memo1: TMemo;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    CheckBox1: TCheckBox;
    TabSheet2: TTabSheet;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    CheckBox2: TCheckBox;
    Edit5: TEdit;
    Label5: TLabel;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    Label6: TLabel;
    Edit6: TEdit;
    Label7: TLabel;
    Edit7: TEdit;
    Label8: TLabel;
    Edit8: TEdit;
    CheckBox5: TCheckBox;
    Label9: TLabel;
    Edit9: TEdit;
    Label10: TLabel;
    Edit10: TEdit;
    Label11: TLabel;
    Edit11: TEdit;
    Label12: TLabel;
    Edit12: TEdit;
    Label13: TLabel;
    Edit13: TEdit;
    Label14: TLabel;
    Edit14: TEdit;
    TabSheet4: TTabSheet;
    Label17: TLabel;
    Edit17: TEdit;
    TabSheet7: TTabSheet;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Edit15: TEdit;
    Edit16: TEdit;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    LockerUserKey: TTabSheet;
    Label26: TLabel;
    Edit19: TEdit;
    CheckBox6: TCheckBox;
    IdHTTPServer1: TIdHTTPServer;
    Label15: TLabel;
    Edit18: TEdit;
    Button3: TButton;
    Button4: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure IdTCPServer1Execute(AThread: TIdPeerThread);
    procedure IdTCPServer1Connect(AThread: TIdPeerThread);
    procedure IdTCPServer1Disconnect(AThread: TIdPeerThread);
    procedure IdTCPServer1Exception(AThread: TIdPeerThread;
      AException: Exception);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure IdHTTPServer1CommandGet(AThread: TIdPeerThread;
      ARequestInfo: TIdHTTPRequestInfo;
      AResponseInfo: TIdHTTPResponseInfo);
    procedure IdHTTPServer1CreatePostStream(ASender: TIdPeerThread;
      var VPostStream: TStream);
  private
    { Private declarations }
    function CodeResult( const s : String ) : String;
    procedure SendResponse( AThread: TIdPeerThread );
    procedure SendResponseHTTP( AThread: TIdPeerThread; ARequestInfo: TIdHTTPRequestInfo; AResponseInfo: TIdHTTPResponseInfo );
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

type
  TStringObject = class
    S : string;
  end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Caption := Application.Title;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  IdTCPServer1.DefaultPort := StrToInt( Edit1.Text );
  IdTCPServer1.Active := True;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  IdTCPServer1.Active := False;
end;

function TForm1.CodeResult( const s : String ) : String;
var
  package, header, parameters, items, item, payments, payment, lockers, n : IXMLNode;
  xmld : IXMLDocument;
  res, i : Integer;
  name, userdata, x, version : String;
  pin : Boolean;
begin
  res := ERROR_INVALID_PARAMETER;
  userdata := '';

  CoInitialize(nil);
  try
    xmld := TXMLDocument.Create( nil );
    xmld.XML.Text := s;
    xmld.Active := True;

    try
      if xmld.DocumentElement.NodeName <> 'package' then raise Exception.Create('');

      n := xmld.DocumentElement.ChildNodes.FindNode( 'userdata' );
      if Assigned( n ) then
        userdata := n.NodeValue;

      name := xmld.DocumentElement.ChildNodes.FindNode( 'header' ).ChildNodes.FindNode( 'name' ).NodeValue;

      if FileExists( name + '.Result.xml' ) then
        begin
          xmld := NewXMLDocument;
          xmld.LoadFromFile( name + '.Result.xml' );
          Result := xmld.XML.Text;
          Exit;
        end;

      if ( name <> 'ItemIssue' )    and
         ( name <> 'TicketsErase' ) and
         ( name <> 'Exit' )         and
         ( name <> 'Bill' )         and
         ( name <> 'CardDelivery' ) and
         ( name <> 'Unlock' )       and
         ( name <> 'CardInfo' )     and
         ( name <> 'CardInfo01' )   and
         ( name <> 'CardInfo02' )   and
         ( name <> 'BlackList' )    and
         ( name <> 'WhiteList' )    and
         ( name <> 'Repair' )       and
         ( name <> 'Disable' )      and
         ( name <> 'GetCard' )      and
         ( name <> 'LockerInfo' )   and
         ( name <> 'LockersInfo' )  and
         ( name <> 'ExternalDeliveryInfo' ) and
         ( name <> 'ExternalDeliveryPost' ) and
         ( name <> 'Barcode' )              and
         ( name <> 'Occupation' )           and
         ( name <> 'External' )             and
         ( name <> 'MemberExport' )         and
         ( name <> 'MemberImport' )         and
         ( name <> 'LockerUserKey' )        and
         ( name <> 'LockerEvent' )          and
         ( name <> 'LockerELSNETSale' )     and
         ( name <> 'LockerELSNETFree' )     and
         ( name <> 'LockerELSNETInfo' )     then raise Exception.Create('');

      version := xmld.DocumentElement.ChildNodes.FindNode( 'header' ).ChildNodes.FindNode( 'version' ).NodeValue;

      parameters := xmld.DocumentElement.ChildNodes.FindNode( 'parameters' );

      if Assigned( parameters ) then
        begin
          if name <> 'ExternalDeliveryInfo' then
            begin
              n := parameters.ChildNodes.FindNode( 'pos' );
              if Assigned( n ) then StrToInt( n.NodeValue );

              n := parameters.ChildNodes.FindNode( 'user' );
              if Assigned( n ) then StrToInt( n.NodeValue );
            end;
        end;

      if name = 'ItemIssue' then
        parameters.ChildNodes.FindNode( 'item' ).NodeValue;

      if ( name = 'ItemIssue' )    or
         ( name = 'TicketsErase' ) or
         ( name = 'Exit' )         or
         ( name = 'CardDelivery' ) or
         ( name = 'CardInfo' )     or
         ( name = 'BlackList' )    or
         ( name = 'WhiteList' )    or
         ( name = 'CardInfo01' )   or
         ( name = 'CardInfo02' )   or
         ( name = 'Repair' )       or
         ( name = 'Disable' )      or
         ( name = 'External' )     then
        parameters.ChildNodes.FindNode( 'card' ).NodeValue;

      pin := Assigned( parameters.ChildNodes.FindNode( 'pin' ) );

      if ( name = 'Bill' ) or ( name = 'CardDelivery' ) then
        begin
          items := parameters.ChildNodes.FindNode( 'items' );
          if Assigned( items ) then
            for i := 0 to items.ChildNodes.Count - 1 do
              begin
                item := items.ChildNodes[ i ];
                if item.NodeName <> 'item' then raise Exception.Create('');
                n := item.ChildNodes.FindNode( 'id' );
                if not Assigned( n ) then
                  n := item.ChildNodes.FindNode( 'import' );
                x := 'item: ' + n.NodeValue;
                x := x + ', ' + item.ChildNodes.FindNode( 'value' ).NodeValue;
                x := x + ', ' + item.ChildNodes.FindNode( 'num' ).NodeValue + 'x';
                Memo1.Lines.Add( x );
              end;
        end;
      if ( name = 'Bill' ) then
        begin
          payments := parameters.ChildNodes.FindNode( 'payments' );
          if Assigned( payments ) then
            for i := 0 to payments.ChildNodes.Count - 1 do
              begin
                payment := payments.ChildNodes[ i ];
                if payment.NodeName <> 'payment' then raise Exception.Create('');
                n := payment.ChildNodes.FindNode( 'id' );
                if not Assigned( n ) then
                  n := payment.ChildNodes.FindNode( 'import' );
                x := 'payment: ' + n.NodeValue;
                x := x + ', ' + payment.ChildNodes.FindNode( 'value' ).NodeValue;
                n := payment.ChildNodes.FindNode( 'count' );
                if Assigned( n ) then
                  x := x + ', ' + n.NodeValue;
                Memo1.Lines.Add( x );
              end;
        end;
      if ( Name = 'Unlock' ) then
        begin
          parameters.ChildNodes.FindNode( 'locker' ).NodeValue;
        end;
      if ( Name = 'Disable' ) then
        begin
          n := parameters.ChildNodes.FindNode( 'refund' );
          if Assigned( n ) then
            if n.NodeValue <> 'disable' then raise Exception.Create('');
        end;

      (*
      n := parameters.ChildNodes.FindNode( 'datetimefrom' );
      *)

      res := ERROR_SUCCESS;

      if ( name = 'CardDelivery' ) then
        begin
          if CheckBox1.Checked then res := ERROR_INVALID_FUNCTION;
        end;
      if ( name = 'LockerUserKey' ) then
        begin
          res := StrToInt( Edit19.Text );
        end;
    except
    end;

    xmld := NewXMLDocument;
    xmld.Encoding := 'UTF-8';
    xmld.StandAlone := 'yes';

    package := xmld.AddChild( 'package' );

    header := package.AddChild( 'header' );
    header.AddChild( 'name' ).NodeValue := 'Result';
    header.AddChild( 'version' ).NodeValue := '1.0';

    parameters := package.AddChild( 'parameters' );
    parameters.AddChild( 'result' ).NodeValue := res;

    if userdata <> '' then package.AddChild( 'userdata' ).NodeValue := userdata;

    if res = ERROR_SUCCESS then
      begin
        if ( name = 'CardInfo01' ) and ( version = '1.0' ) then
          begin
            if CheckBox2.Checked then
              begin
                with parameters.AddChild( 'used' ) do
                  begin
                    AddChild( 'count' ).NodeValue := Edit5.Text;
                  end;
              end;
            if CheckBox3.Checked then
              begin
                with parameters.AddChild( 'charge' ) do
                  begin
                    AddChild( 'minutes' ).NodeValue := Edit2.Text;
                    AddChild( 'entrance' ).NodeValue := Edit3.Text;
                    AddChild( 'item' ).NodeValue := Edit4.Text;
                  end;
              end;
            if CheckBox4.Checked then
              begin
                with parameters.AddChild( 'refund' ) do
                  begin
                    AddChild( 'minutes' ).NodeValue := Edit6.Text;
                    AddChild( 'entrance' ).NodeValue := Edit7.Text;
                    AddChild( 'item' ).NodeValue := Edit8.Text;
                  end;
              end;
            if CheckBox5.Checked then
              begin
                lockers := parameters.AddChild( 'lockers' );
                if Edit9.Text <> '' then
                  with lockers.AddChild( 'locker' ) do
                    begin
                      AddChild( 'number' ).NodeValue := Edit9.Text;
                      AddChild( 'dt' ).NodeValue := Edit10.Text;
                      if Edit11.Text <> '' then
                        AddChild( 'location' ).NodeValue := Edit11.Text;
                    end;
                if Edit12.Text <> '' then
                  with lockers.AddChild( 'locker' ) do
                    begin
                      AddChild( 'number' ).NodeValue := Edit12.Text;
                      AddChild( 'dt' ).NodeValue := Edit13.Text;
                      if Edit14.Text <> '' then
                        AddChild( 'location' ).NodeValue := Edit14.Text;
                    end;
              end;
          end;
        if ( name = 'CardInfo01' ) and ( version <> '1.0' ) then
          begin
            xmld.LoadFromFile( 'CardInfo01.ver11.Result.xml' );
          end;
        if name = 'CardInfo02' then
          begin
            xmld.LoadFromFile( 'CardInfo02.Result.xml' );
          end;
        if name = 'LockerInfo' then
          begin
            xmld.LoadFromFile( 'LockerInfo.Result.xml' );
          end;
        if name = 'LockersInfo' then
          begin
            xmld.LoadFromFile( 'LockersInfo.Result.xml' );
          end;
        if name = 'GetCard' then
          begin
            parameters.AddChild( 'card' ).NodeValue := Edit17.Text;
          end;
        if name = 'ExternalDeliveryInfo' then
          begin
            xmld.LoadFromFile( 'ExternalDeliveryInfo.Result.xml' );
          end;
        if name = 'Occupation' then
          begin
            xmld.LoadFromFile( 'Occupation.Result.xml' );
          end;
        if name = 'External' then
          begin
            x := 'deny';
            if Edit15.Text <> '' then parameters.AddChild( 'balance' ).NodeValue := Edit15.Text;
            if Edit16.Text <> '' then parameters.AddChild( 'limit' ).NodeValue := Edit16.Text;
            if RadioButton1.Checked then x := 'allow';
            if RadioButton3.Checked then x := 'capture';
            if CheckBox6.Checked then
              begin
                if not pin then x := 'pin request';
              end;
            parameters.AddChild( 'action' ).NodeValue := x;
          end;
        if name = 'MemberExport' then
          begin
            xmld.LoadFromFile( 'MemberExport.Result.xml' );
          end;
        if name = 'MemberImport' then
          begin
            xmld.LoadFromFile( 'MemberImport.Result.xml' );
          end;
        if name = 'LockerELSNETInfo' then
          begin
            xmld.LoadFromFile( 'LockerELSNETInfo.Result.xml' );
          end;
      end;

    Result := xmld.XML.Text;
  finally
    CoUninitialize;
  end;
end;

procedure TForm1.SendResponse( AThread: TIdPeerThread );
var
  s : String;
begin
  s := TStringObject( AThread.Data ).S;

  Memo1.Lines.Add( '----------' );
  Memo1.Lines.Add( s );
  Memo1.Lines.Add( '----------' );

  s := CodeResult( s );

  Memo1.Lines.Add( '==========' );
  Memo1.Lines.Add( s );
  Memo1.Lines.Add( '==========' );

  AThread.Connection.Write( #2 + s + #3 );
end;

procedure TForm1.SendResponseHTTP( AThread: TIdPeerThread; ARequestInfo: TIdHTTPRequestInfo; AResponseInfo: TIdHTTPResponseInfo );
var
  s : String;
begin
  s := TStringStream( ARequestInfo.PostStream ).DataString;

  Memo1.Lines.Add( '----------' );
  Memo1.Lines.Add( s );
  Memo1.Lines.Add( '----------' );

  s := CodeResult( s );

  Memo1.Lines.Add( '==========' );
  Memo1.Lines.Add( s );
  Memo1.Lines.Add( '==========' );

  AResponseInfo.ContentType := 'text/xml';
  AResponseInfo.ContentText := s;
end;

procedure TForm1.IdTCPServer1Execute(AThread: TIdPeerThread);
var
  ch : Char;
begin
  ch := AThread.Connection.ReadChar;
  case ch of
    #0 : ;
    #2 : TStringObject( AThread.Data ).S := '';
    #3 : SendResponse( AThread );
    else TStringObject( AThread.Data ).S := TStringObject( AThread.Data ).S + ch;
  end;
end;

procedure TForm1.IdTCPServer1Connect(AThread: TIdPeerThread);
begin
  AThread.Data := TStringObject.Create;
  Memo1.Lines.Add( Format( '%s Connect', [
    AThread.Connection.Socket.Binding.PeerIP
  ] ) );
end;

procedure TForm1.IdTCPServer1Disconnect(AThread: TIdPeerThread);
begin
  Memo1.Lines.Add( Format( '%s Disconnect', [ AThread.Connection.Socket.Binding.PeerIP ] ) );
end;

procedure TForm1.IdTCPServer1Exception(AThread: TIdPeerThread;
  AException: Exception);
begin
  Memo1.Lines.Add( '**********' );
  Memo1.Lines.Add( AException.Message );
  Memo1.Lines.Add( '**********' );
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  IdHTTPServer1.DefaultPort := StrToInt( Edit18.Text );
  IdHTTPServer1.Active := True;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  IdHTTPServer1.Active := False;
end;

procedure TForm1.IdHTTPServer1CommandGet(AThread: TIdPeerThread;
  ARequestInfo: TIdHTTPRequestInfo; AResponseInfo: TIdHTTPResponseInfo);
begin
  Memo1.Lines.Add( Format( '%s Command', [
    AThread.Connection.Socket.Binding.PeerIP
  ] ) );

  SendResponseHTTP(AThread, ARequestInfo, AResponseInfo);
end;

procedure TForm1.IdHTTPServer1CreatePostStream(ASender: TIdPeerThread;
  var VPostStream: TStream);
begin
  VPostStream := TStringStream.Create( '' );
end;

end.
